// zooflow.js - ZooFlow 流量傳送門 V1.0
// --------------------------------------------------
(function() {
    console.log("🦁 ZooFlow SDK: 初始化...");

    // 1. 設定 API 來源 (指向您的 HTTPS 主機)
    const API_ENDPOINT = "https://flowzoo.com.tw/flowzoo/api/mission.php";

    // 2. 建立樣式 (Fox 的堅持：不破壞宿主網站，只佔用右下角)
    const style = document.createElement('style');
    style.innerHTML = `
        #zoo-widget-container {
            position: fixed;
            bottom: 20px;
            right: 20px;
            z-index: 9999; /* 確保在最上層 */
            font-family: 'Microsoft JhengHei', sans-serif;
            cursor: pointer;
            transition: transform 0.3s;
        }
        #zoo-widget-container:hover {
            transform: scale(1.05);
        }
        #zoo-mascot {
            width: 120px; /* 兔子大小 */
            filter: drop-shadow(0 5px 15px rgba(0,0,0,0.3));
        }
        #zoo-bubble {
            position: absolute;
            top: -40px;
            right: 20px;
            background: #fff;
            color: #000;
            padding: 8px 12px;
            border-radius: 15px;
            font-size: 12px;
            font-weight: bold;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            white-space: nowrap;
            opacity: 0;
            transition: opacity 0.5s;
            pointer-events: none;
        }
        #zoo-widget-container:hover #zoo-bubble {
            opacity: 1;
        }
    `;
    document.head.appendChild(style);

    // 3. 召喚兔子 (Fetch API)
    async function summonRabbit() {
        try {
            const response = await fetch(API_ENDPOINT);
            const data = await response.json();

            if (data.status === 'active') {
                createWidget(data);
            }
        } catch (error) {
            console.warn("ZooFlow SDK: 連線失敗，兔子今天休假。", error);
        }
    }

    // 4. 渲染畫面 (DOM Manipulation)
    function createWidget(data) {
        const container = document.createElement('div');
        container.id = 'zoo-widget-container';
        
        // 點擊事件：跳轉到指定連結
        container.onclick = function() {
            window.open(data.link, '_blank');
        };

        // 插入圖片
        const img = document.createElement('img');
        img.id = 'zoo-mascot';
        img.src = data.image_url;
        img.alt = "ZooFlow Mascot";

        // 插入對話框
        const bubble = document.createElement('div');
        bubble.id = 'zoo-bubble';
        bubble.innerText = data.message;

        container.appendChild(bubble);
        container.appendChild(img);
        document.body.appendChild(container);

        console.log("🦁 ZooFlow SDK: 兔子已抵達戰場！");
    }

    // 啟動
    summonRabbit();

})();