<?php
// fix_names.php - 資產自動標準化腳本 (Zoo Team Tool)
// --------------------------------------------------
header("Content-Type: text/plain; charset=utf-8");

// 設定圖片目錄
$dir = __DIR__ . '/images/';
if (!is_dir($dir)) {
    die("❌ 錯誤：找不到 images 資料夾，請先建立並上傳圖片。");
}

// 定義「尾數」對應「新檔名」的映射表 (根據剛才的安家計畫)
$map = [
    '24' => 'zoo_hi.jpg',           // 吾乃伏羲
    '11' => 'zoo_idle.jpg',         // 待命狀態
    '22' => 'zoo_loading.jpg',      // 交給我吧
    '18' => 'zoo_done.jpg',         // 報告完畢
    '21' => 'zoo_admin.jpg',        // 天啟
    '5'  => 'zoo_success.jpg',      // 恭喜過關
    '16' => 'zoo_miracle.jpg',      // 見證奇蹟
    '20' => 'zoo_rich.jpg',         // 百萬期望值
    '17' => 'zoo_morale.jpg',       // 團隊士氣
    '6'  => 'zoo_go.jpg',           // 3,2,1 GO
    '19' => 'zoo_start.jpg',        // 遊戲開始
    '3'  => 'zoo_error_pit.jpg',    // 大坑 (Error)
    '8'  => 'zoo_gameover.jpg',     // 遊戲結束
    '7'  => 'zoo_cheat.jpg',        // 作弊 (Cheat)
    '2'  => 'zoo_ban.jpg',          // 天譴 (Ban)
    '12' => 'zoo_badguy.jpg',       // 不良人
    '15' => 'zoo_low_power.jpg',    // 算力用罄
    '14' => 'zoo_ask.jpg',          // 下一步指令
    '1'  => 'zoo_new_task.jpg',     // 任務來了
    '10' => 'zoo_action_like.jpg',  // 按讚打卡
    '4'  => 'zoo_action_video.jpg', // 請看VCR
    '13' => 'zoo_yes.jpg',          // 遵命
    '9'  => 'zoo_phoenix.jpg',      // 鳳凰計畫
    '23' => 'zoo_retry.jpg'         // 再來一次
];

echo "🦁 Zoo Team 資產整隊開始...\n\n";
echo "目標資料夾: $dir \n------------------------\n";

// 掃描資料夾
$files = scandir($dir);
$count = 0;

foreach ($files as $file) {
    if ($file === '.' || $file === '..') continue;

    // 嘗試從檔名中抓出尾數 (例如 ..._24.jpg 抓出 24)
    // 正則表達式：尋找底線後面的數字，接著是 .jpg
    if (preg_match('/_(\d+)\.jpg$/i', $file, $matches)) {
        $id = $matches[1]; // 抓到的數字
        
        if (isset($map[$id])) {
            $newName = $map[$id];
            $oldPath = $dir . $file;
            $newPath = $dir . $newName;

            // 執行改名
            if (rename($oldPath, $newPath)) {
                echo "✅ [成功] $file -> $newName\n";
                $count++;
            } else {
                echo "❌ [失敗] 無法更名 $file\n";
            }
        }
    }
}

echo "------------------------\n";
echo "🎉 整隊完成！共處理了 $count 張圖片。\n";
echo "現在您可以刪除此腳本，並前往 index.html 測試了。";
?>