<?php
// update_duration.php - 時空容器擴充
// --------------------------------------------------
header("Content-Type: text/plain; charset=utf-8");
require_once 'db.php';

echo "🦁 Zoo Team 時間膨脹程序啟動...\n";

try {
    // 為 tasks 資料表增加 duration 欄位，預設 20 秒
    $sql = "ALTER TABLE tasks ADD COLUMN duration INT DEFAULT 20 COMMENT '任務秒數' AFTER target_url";
    
    $pdo->exec($sql);
    echo "✅ [成功] 資料庫結構已升級！新增 'duration' 欄位。\n";
    echo "   - 現在支援：20s, 60s, 120s, 300s\n";

} catch (PDOException $e) {
    // 如果欄位已存在，會報錯，這是正常的防呆
    if (strpos($e->getMessage(), "Duplicate column") !== false) {
        echo "✅ [略過] 欄位 'duration' 已經存在，無需重複新增。\n";
    } else {
        echo "❌ [失敗] 資料庫錯誤：" . $e->getMessage();
    }
}
?>