<?php
// test_cors.php - 跨網域斥候信標
// --------------------------------------------------
header("Access-Control-Allow-Origin: *"); // 關鍵：允許所有來源
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// 處理預檢請求 (Preflight)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

echo json_encode([
    "status" => "success",
    "message" => "CORS 訊號正常！",
    "protocol" => isset($_SERVER['HTTPS']) ? 'HTTPS (安全)' : 'HTTP (一般)',
    "timestamp" => date("Y-m-d H:i:s")
]);
?>