<?php
// 🐆 Cheetah's Probe: test.php
// 用途：視覺化測試資料庫連線與資料表狀態

header('Content-Type: text/html; charset=utf-8');
require 'db.php'; // 呼叫 Elephant 的連線檔

echo "<!DOCTYPE html><html lang='zh-TW'><head><meta charset='UTF-8'><title>ZooFlow 系統檢測</title>";
echo "<style>body{font-family: sans-serif; background: #1a1a1a; color: #fff; text-align: center; padding: 50px;}";
echo ".box{border: 2px solid #333; padding: 20px; max-width: 600px; margin: 0 auto; background: #222; border-radius: 10px;}";
echo ".success{color: #00ff00; font-weight: bold;}";
echo ".error{color: #ff0000; font-weight: bold;}";
echo "</style></head><body>";

echo "<div class='box'>";
echo "<h2>🐆 ZooFlow 系統檢測終端</h2>";
echo "<hr style='border-color: #444;'>";

try {
    // 1. 測試連線狀態
    if ($pdo) {
        echo "<p>✅ 資料庫連線：<span class='success'>連結確立 (Connection Established)</span></p>";
    }

    // 2. 測試讀取 Users 表
    $stmt = $pdo->query("SELECT count(*) FROM users");
    $count = $stmt->fetchColumn();

    echo "<p>✅ Users 資料表：<span class='success'>讀取成功</span></p>";
    echo "<p>👥 目前用戶總數：<span style='color: #00ffff; font-size: 1.2em;'>$count</span> 人</p>";
    
    // 3. 顯示一點激勵的話
    if ($count > 0) {
        echo "<hr style='border-color: #444;'>";
        echo "<p style='color: #aaa;'>太棒了 Boss！創世者帳號 (ZooMaster) 已經在裡面了！<br>我們可以開始寫登入介面了！</p>";
    } else {
        echo "<hr style='border-color: #444;'>";
        echo "<p style='color: orange;'>警告：資料庫連上了，但裡面沒人？<br>請確認是否有執行 INSERT 創世者指令。</p>";
    }

} catch (PDOException $e) {
    // 捕捉錯誤
    echo "<p>❌ 狀態：<span class='error'>系統異常</span></p>";
    echo "<div style='background: #300; padding: 10px; text-align: left; font-size: 0.9em; overflow: auto;'>";
    echo "錯誤訊息 (Error): " . $e->getMessage();
    echo "</div>";
    echo "<p>💡 建議：請檢查 <code>db.php</code> 裡面的帳號密碼是否正確。</p>";
}

echo "</div></body></html>";
?>