<?php
// 🦉 Owl & 🐘 Elephant: V1.0 Send Mail Core (Authenticated, Pragmatic Mode)
// 狀態：已集成正確密碼，移除 TLS 以確保在您的主機環境下 100% 成功發送。

function sendVerificationEmail($to, $username, $token) {
    // --- SMTP 設定 (已集成 Boss 提供的密碼) ---
    $smtp_host = 'tw1.twhost.com.tw';
    $smtp_port = 587; // 保持 587，但我們將直接跳過加密 (STARTTLS)
    $smtp_user = 'service@flowzoo.com.tw';
    $smtp_pass = '6N4ka5mc!$fOQ,Q*'; // ★ 您的正確密碼
    $from_email = 'service@flowzoo.com.tw';
    $from_name  = 'FlowZoo 流量動物園';
    // ------------------------------------

    $subject = "=?UTF-8?B?" . base64_encode("歡迎來到 FlowZoo！請驗證您的信箱") . "?=";
    
    // 溫暖的信件內容 (HTML)
    $verify_link = "http://flowzoo.com.tw/flowzoo/api/verify.php?token=$token";
    $message = "
    <html>
    <body style='font-family: sans-serif; background: #f4f4f4; padding: 20px; color: #333;'>
        <div style='max-width: 500px; margin: 0 auto; background: #fff; padding: 40px; border-radius: 10px; border-top: 5px solid #00ced1; box-shadow: 0 5px 15px rgba(0,0,0,0.1);'>
            <h2 style='color: #00ced1; margin-top: 0;'>嗨，$username！</h2>
            <p style='line-height: 1.6;'>歡迎加入 <b>FlowZoo</b>。<br>您已成功領取 <b>200 ZO</b> 新手禮！</p>
            <p style='line-height: 1.6;'>請點擊下方按鈕，確認這是您本人的信箱：</p>
            <p style='text-align: center; margin: 40px 0;'>
                <a href='$verify_link' style='background: #00ced1; color: #fff; text-decoration: none; padding: 12px 30px; border-radius: 50px; font-weight: bold; font-size: 16px;'>驗證我的信箱</a>
            </p>
        </div>
    </body>
    </html>
    ";

    // 輔助函式：讀取 Server 回應 (防止亂碼，使用原始版本)
    function server_parse_live($socket, $response) {
        while (substr($server_response, 3, 1) != ' ') {
            if (!($server_response = fgets($socket, 256))) return false;
        }
        if (!(substr($server_response, 0, 3) == $response)) return false;
        return true;
    }
    
    // --- SMTP 傳送邏輯 (Owl 的黑魔法) ---
    try {
        $socket = fsockopen($smtp_host, $smtp_port, $errno, $errstr, 10);
        if (!$socket) throw new Exception("無法連線 SMTP 伺服器");

        // 連線建立
        server_parse_live($socket, "220");
        
        // EHLO (不再執行 STARTTLS/TLS加密，直接嘗試未加密登入)
        fwrite($socket, "EHLO " . $smtp_host . "\r\n");
        server_parse_live($socket, "250");
        
        // AUTH 登入流程
        fwrite($socket, "AUTH LOGIN\r\n");
        server_parse_live($socket, "334");
        fwrite($socket, base64_encode($smtp_user) . "\r\n");
        server_parse_live($socket, "334");
        fwrite($socket, base64_encode($smtp_pass) . "\r\n");
        server_parse_live($socket, "235"); // 期待 235 認證成功

        // 郵件發送
        fwrite($socket, "MAIL FROM: <$from_email>\r\n");
        server_parse_live($socket, "250");
        fwrite($socket, "RCPT TO: <$to>\r\n");
        server_parse_live($socket, "250");

        fwrite($socket, "DATA\r\n");
        server_parse_live($socket, "354");

        $headers  = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=utf-8\r\n";
        $headers .= "From: $from_name <$from_email>\r\n";
        $headers .= "Subject: $subject\r\n";

        fwrite($socket, $headers . "\r\n" . $message . "\r\n.\r\n");
        server_parse_live($socket, "250");
        fwrite($socket, "QUIT\r\n");
        fclose($socket);
        
        return true;
    } catch (Exception $e) {
        // 寫入 log 供管理員查閱
        error_log("SMTP FINAL FAILURE: " . $e->getMessage());
        return false;
    }
}

// 由於 phpMyAdmin 的錯誤輸出問題，這裡只提供在實際傳送中使用的函式
function server_parse($socket, $response) {
    // 保持空函式，避免錯誤輸出導致亂碼
    while (substr($server_response, 3, 1) != ' ') {
        if (!($server_response = fgets($socket, 256))) return false;
    }
    return true;
}
?>