<?php
// 🦉 Owl's Native SMTP Core
// 用途：負責發送 20°C 的溫暖驗證信 (不依賴 PHPMailer)

function sendVerificationEmail($to, $username, $token) {
    // --- SMTP 設定 (請填入您的真實資訊) ---
    $smtp_host = 'tw1.twhost.com.tw';
    $smtp_port = 587;
    $smtp_user = 'service@flowzoo.com.tw'; // 您的寄件帳號
    $smtp_pass = 'X)m(9E,3x^VsvBE-';   // ★ 關鍵：請修改這裡！
    $from_email = 'service@flowzoo.com.tw';
    $from_name  = 'FlowZoo 流量動物園';
    // ------------------------------------

    $subject = "=?UTF-8?B?" . base64_encode("歡迎來到 FlowZoo！請驗證您的信箱") . "?=";
    
    // 驗證連結 (指向未來的 verify.php)
    $verify_link = "http://flowzoo.com.tw/flowzoo/api/verify.php?token=$token";
    
    // 信件內容 (HTML)
    $message = "
    <html>
    <body style='font-family: sans-serif; background: #f4f4f4; padding: 20px; color: #333;'>
        <div style='max-width: 500px; margin: 0 auto; background: #fff; padding: 40px; border-radius: 10px; border-top: 5px solid #00ced1; box-shadow: 0 5px 15px rgba(0,0,0,0.1);'>
            <h2 style='color: #00ced1; margin-top: 0;'>嗨，$username！</h2>
            <p style='line-height: 1.6;'>歡迎加入 <b>FlowZoo</b>。<br>這裡目前的溫度是舒適的 20°C。</p>
            <p style='line-height: 1.6;'>依照 Base 20 法則，您的帳戶已預先存入 <b>200 ZO</b> 的新手禮。</p>
            <p style='line-height: 1.6;'>請點擊下方按鈕，確認這是您本人的信箱：</p>
            <p style='text-align: center; margin: 40px 0;'>
                <a href='$verify_link' style='background: #00ced1; color: #fff; text-decoration: none; padding: 12px 30px; border-radius: 50px; font-weight: bold; font-size: 16px;'>驗證我的信箱</a>
            </p>
            <hr style='border: 0; border-top: 1px solid #eee; margin: 30px 0;'>
            <p style='color: #999; font-size: 0.8em; text-align: center;'>FlowZoo Team • 讓頻率共振</p>
        </div>
    </body>
    </html>
    ";

    // --- SMTP 傳送邏輯 (Socket 通訊) ---
    try {
        $socket = fsockopen($smtp_host, $smtp_port, $errno, $errstr, 10);
        if (!$socket) return false;

        // 讀取伺服器回應並發送指令
        server_parse($socket, "220");
        fwrite($socket, "EHLO " . $smtp_host . "\r\n");
        server_parse($socket, "250");
        fwrite($socket, "STARTTLS\r\n");
        server_parse($socket, "220");
        stream_socket_enable_crypto($socket, true, STREAM_CRYPTO_METHOD_TLS_CLIENT);
        fwrite($socket, "EHLO " . $smtp_host . "\r\n");
        server_parse($socket, "250");
        fwrite($socket, "AUTH LOGIN\r\n");
        server_parse($socket, "334");
        fwrite($socket, base64_encode($smtp_user) . "\r\n");
        server_parse($socket, "334");
        fwrite($socket, base64_encode($smtp_pass) . "\r\n"); // 傳送密碼
        server_parse($socket, "235"); // 驗證成功

        fwrite($socket, "MAIL FROM: <$from_email>\r\n");
        server_parse($socket, "250");
        fwrite($socket, "RCPT TO: <$to>\r\n");
        server_parse($socket, "250");

        fwrite($socket, "DATA\r\n");
        server_parse($socket, "354");

        $headers  = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=utf-8\r\n";
        $headers .= "From: $from_name <$from_email>\r\n";
        $headers .= "To: $to\r\n";
        $headers .= "Subject: $subject\r\n";

        fwrite($socket, $headers . "\r\n" . $message . "\r\n.\r\n");
        server_parse($socket, "250");
        fwrite($socket, "QUIT\r\n");
        fclose($socket);
        
        return true;
    } catch (Exception $e) {
        return false;
    }
}

// 輔助函式
function server_parse($socket, $response) {
    $server_response = '';
    while (substr($server_response, 3, 1) != ' ') {
        if (!($server_response = fgets($socket, 256))) return false;
    }
}
?>