<?php
// seed_tasks.php - 創世紀播種計畫 (產生示範數據)
// --------------------------------------------------
header("Content-Type: text/plain; charset=utf-8");
require_once 'db.php';

echo "🦁 Zoo Team 播種程序啟動...\n\n";

try {
    // 定義種子任務 (官方示範)
    $seeds = [
        [
            'platform' => 'WEB',
            'action_type' => 'VIEW',
            'target_url' => 'https://flowzoo.com.tw/flowzoo/index.html',
            'proof_req' => 'AUTO',
            'cost' => 20,
            'reward' => 15,
            'warmth_bonus' => 0
        ],
        [
            'platform' => 'FB_PAGE',
            'action_type' => 'LIKE',
            'target_url' => 'https://www.facebook.com/hoelex', // 範例：HOELEX 老師粉專
            'proof_req' => 'SCREENSHOT',
            'cost' => 30, // 官方加碼
            'reward' => 25,
            'warmth_bonus' => 1 // 開啟打賞
        ],
        [
            'platform' => 'PTT',
            'action_type' => 'COMMENT',
            'target_url' => 'https://www.ptt.cc/bbs/DigiCurrency/M.123456.html', // 範例
            'proof_req' => 'LINK',
            'cost' => 50, // 高難度任務
            'reward' => 40,
            'warmth_bonus' => 1
        ]
    ];

    $sql = "INSERT INTO tasks (user_id, platform, action_type, target_url, proof_req, cost, reward, warmth_bonus) 
            VALUES (1, :platform, :action_type, :target_url, :proof_req, :cost, :reward, :warmth_bonus)";
    
    $stmt = $pdo->prepare($sql);

    foreach ($seeds as $seed) {
        $stmt->execute($seed);
        echo "🌱 [播種成功] 類型: {$seed['platform']} | 獎勵: {$seed['reward']} Z幣\n";
    }

    echo "\n--------------------------------\n";
    echo "✅ 創世紀完成！目前任務倉已有生命。\n";
    echo "接下來我們可以安心建造「任務大廳」的 UI 了。\n";

} catch (PDOException $e) {
    echo "❌ [失敗] 播種錯誤：" . $e->getMessage();
}
?>