<?php
// register.php - ZOO 註冊接口 (V2.1 穩定修復版)
// --------------------------------------------------
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

// 1. 引入正確的心臟
require_once 'db.php';

// 2. 接收數據 (兼容 JSON 與 POST 表單)
$input = file_get_contents("php://input");
$data = json_decode($input, true);

// 如果 JSON 解碼失敗，嘗試讀取 $_POST (Form Data)
if (json_last_error() !== JSON_ERROR_NONE) {
    $username = $_POST['username'] ?? null;
    $password = $_POST['password'] ?? null;
    $email    = $_POST['email'] ?? null;
} else {
    $username = $data['username'] ?? null;
    $password = $data['password'] ?? null;
    $email    = $data['email'] ?? null;
}

// 3. 基本驗證
if (!$username || !$password || !$email) {
    echo json_encode(["status" => "error", "message" => "資料不完整 (需帳號、密碼、信箱)"]);
    exit;
}

try {
    $pdo->beginTransaction();

    // 4. 檢查重複 (帳號或信箱)
    $stmt = $pdo->prepare("SELECT id FROM users WHERE username = :user OR email = :email");
    $stmt->execute([':user' => $username, ':email' => $email]);
    if ($stmt->fetch()) {
        throw new Exception("此帳號或信箱已被註冊");
    }

    // 5. 加密與設定
    $password_hash = password_hash($password, PASSWORD_DEFAULT);
    $initial_coins = 200; // Base 20 法則

    // 6. 寫入資料庫
    $sql = "INSERT INTO users (username, email, password_hash, coins, level) 
            VALUES (:user, :email, :hash, :coins, 1)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':user' => $username,
        ':email' => $email,
        ':hash' => $password_hash,
        ':coins' => $initial_coins
    ]);

    $pdo->commit();

    echo json_encode([
        "status" => "success",
        "message" => "註冊成功！",
        "data" => [
            "username" => $username,
            "coins" => $initial_coins
        ]
    ]);

} catch (Exception $e) {
    $pdo->rollBack();
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
?>