<?php
// patch_duration.php - 為資料庫植入「時間觀念」
// --------------------------------------------------
header("Content-Type: text/plain; charset=utf-8");
require_once 'db.php'; // 引入修復後的心臟

echo "🦁 Zoo Team 微創手術開始...\n";

try {
    // 指令：在 target_url 後面，新增一個 duration 欄位，預設 20 (秒)
    $sql = "ALTER TABLE tasks ADD COLUMN duration INT DEFAULT 20 COMMENT '任務秒數' AFTER target_url";
    
    $pdo->exec($sql);
    echo "✅ [手術成功] 資料庫已升級！\n";
    echo "   - 新增欄位：duration (時長)\n";
    echo "   - 現在您可以發布 60秒 / 120秒 / 300秒 的任務了。";

} catch (PDOException $e) {
    // 防呆：如果欄位已經存在，會報錯，我們把它當作沒事
    if (strpos($e->getMessage(), "Duplicate column") !== false) {
        echo "✅ [略過] 手術已完成過 (欄位已存在)，系統正常。\n";
    } else {
        echo "❌ [手術失敗] 錯誤訊息：" . $e->getMessage();
    }
}
?>