<?php
// login.php - ZOO 登入接口 (V2.4 最終修復版)
// --------------------------------------------------
// 1. 強制顯示錯誤 (這是為了讓白屏消失，顯示真正原因)
ini_set('display_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");

// 2. 處理跨域與直接點擊測試 (GET)
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit;
}
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    // 這是給您直接點擊連結測試用的
    echo json_encode(["success" => true, "message" => "🟢 ZOO Login Gateway Active (系統活著)"]);
    exit;
}

// 3. 檢查心臟 (db.php) 是否存在
if (!file_exists('db.php')) {
    echo json_encode(["success" => false, "message" => "❌ 系統錯誤：找不到 api/db.php，請檢查檔案位置。"]);
    exit;
}

// 4. 引入心臟 (直接連線，不透過 conn.php)
require_once 'db.php'; 

// 5. 接收資料
$input = file_get_contents("php://input");
$data = json_decode($input, true);

if (empty($data) || !isset($data['username']) || !isset($data['password'])) {
    echo json_encode(["success" => false, "message" => "請輸入帳號與密碼"]);
    exit;
}

$username = $data['username'];
$password = $data['password'];

try {
    // 6. 驗證使用者
    $sql = "SELECT id, username, password_hash, coins FROM users WHERE username = :username";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':username' => $username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // 7. 密碼比對 (包含明碼容錯)
    $is_valid = false;
    if ($user) {
        if (password_verify($password, $user['password_hash'])) {
            $is_valid = true;
        } elseif ($user['password_hash'] === $password) {
            $is_valid = true; // 允許明碼 (測試用)
        }
    }

    if (!$is_valid) {
        echo json_encode(["success" => false, "message" => "帳號或密碼錯誤"]);
        exit;
    }

    // 8. 查詢天眼數據 (任務數) - 防止因資料表缺失而報錯
    $mission_count = 0;
    try {
        $stmt_logs = $pdo->query("SELECT COUNT(*) FROM tasks WHERE status = 'active'");
        if($stmt_logs) $mission_count = $stmt_logs->fetchColumn();
    } catch (Exception $e) { $mission_count = 0; }

    // 9. 回傳成功數據
    echo json_encode([
        "success" => true,
        "status" => "success",
        "message" => "登入成功",
        "data" => [
            "user_id" => $user['id'],
            "username" => $user['username'],
            "coins" => $user['coins'],
            "traffic" => $mission_count
        ]
    ]);

} catch (PDOException $e) {
    echo json_encode(["success" => false, "message" => "資料庫錯誤: " . $e->getMessage()]);
}
?>