<?php
// install_radar.php - 天眼雷達安裝程式
// --------------------------------------------------
header("Content-Type: text/plain; charset=utf-8");
require_once 'db.php'; // 呼叫心臟

echo "🦁 Zoo Team 天眼安裝程序啟動...\n\n";

try {
    // 定義資料表結構：任務日誌
    // id: 流水號
    // ip: 訪客 IP
    // mission: 執行的任務代號
    // created_at: 時間戳記
    $sql = "CREATE TABLE IF NOT EXISTS mission_logs (
        id INT AUTO_INCREMENT PRIMARY KEY,
        ip VARCHAR(45),
        mission VARCHAR(50),
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP
    ) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;";

    $pdo->exec($sql);
    echo "✅ [成功] 資料表 'mission_logs' (黑盒子) 已就緒。\n";
    echo "   - 結構：ID | IP | MISSION | TIME\n";
    echo "   - 狀態：等待數據寫入...\n";

} catch (PDOException $e) {
    echo "❌ [失敗] 安裝錯誤：" . $e->getMessage();
}

echo "\n--------------------------------\n";
echo "請刪除此檔案，並繼續下一步。";
?>