<?php
// install_foundation.php - V1.5 暖心生態系基石安裝
// --------------------------------------------------
header("Content-Type: text/plain; charset=utf-8");
require_once 'db.php'; // 呼叫心臟

echo "🦁 Zoo Team 基石鑄造程序啟動...\n";
echo "🌡️ 當前溫度設定：20°C (冷靜/穩固)\n\n";

try {
    // --------------------------------------------------
    // 1. 建立任務倉 (Tasks)
    // --------------------------------------------------
    // platform: 支援 WEB, FB, IG, YT, TIKTOK, PTT, DCARD
    // proof_req: AUTO(自動), SCREENSHOT(截圖), LINK(連結)
    // warmth_bonus: 是否開啟打賞機制 (0/1)
    
    $sql_tasks = "CREATE TABLE IF NOT EXISTS tasks (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        platform VARCHAR(20) NOT NULL COMMENT '平台類型',
        action_type VARCHAR(20) NOT NULL COMMENT '按讚/留言/瀏覽',
        target_url TEXT NOT NULL COMMENT '目標網址',
        cost INT DEFAULT 20 COMMENT '發布成本',
        reward INT DEFAULT 15 COMMENT '完成獎勵',
        proof_req VARCHAR(20) DEFAULT 'AUTO' COMMENT '驗證方式',
        warmth_bonus TINYINT DEFAULT 0 COMMENT '是否開啟打賞',
        status ENUM('active', 'paused', 'completed') DEFAULT 'active',
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        INDEX (status),
        INDEX (platform)
    ) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;";

    $pdo->exec($sql_tasks);
    echo "✅ [成功] 資料表 'tasks' (任務倉) 已就緒。\n";
    echo "   - 已寫入七海平台邏輯 (FB/IG/PTT...)\n";
    echo "   - 已鎖定 20/15 經濟模型\n";

    // --------------------------------------------------
    // 2. 建立證物倉 (Proofs)
    // --------------------------------------------------
    // proof_data: 存放截圖檔名或回覆的連結
    // comment: 執行者的暖心留言
    // status: pending(待審), approved(通過), rejected(駁回)
    
    $sql_proofs = "CREATE TABLE IF NOT EXISTS task_proofs (
        id INT AUTO_INCREMENT PRIMARY KEY,
        task_id INT NOT NULL,
        worker_id INT NOT NULL COMMENT '執行者ID',
        proof_data TEXT COMMENT '截圖路徑或連結',
        comment TEXT COMMENT '暖心留言',
        status ENUM('pending', 'approved', 'rejected') DEFAULT 'pending',
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        INDEX (task_id),
        INDEX (worker_id),
        INDEX (status)
    ) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;";

    $pdo->exec($sql_proofs);
    echo "✅ [成功] 資料表 'task_proofs' (證物倉) 已就緒。\n";
    echo "   - 已準備好承載截圖與留言\n";
    echo "   - 審核機制邏輯已建立\n";

} catch (PDOException $e) {
    echo "❌ [失敗] 基石安裝錯誤：" . $e->getMessage();
}

echo "\n--------------------------------\n";
echo "基石已立，等待介面建設。\n";
echo "請刪除此檔案，並回報 Lion。";
?>