<?php
// god_blessing.php - 天官賜福 (測試專用儲值)
// --------------------------------------------------
header("Content-Type: text/plain; charset=utf-8");
require_once 'db.php';

echo "🦁 Zoo Team 金庫緊急通道開啟...\n";

// 設定要賜福的帳號 (預設為 zoo_champion)
$username = 'zoo_champion'; 
$amount = 10000;

try {
    // 直接修改資料庫
    $sql = "UPDATE users SET coins = coins + :amount WHERE username = :user";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':amount' => $amount, ':user' => $username]);

    // 查詢最新餘額
    $sql_check = "SELECT coins FROM users WHERE username = :user";
    $stmt_check = $pdo->prepare($sql_check);
    $stmt_check->execute([':user' => $username]);
    $new_balance = $stmt_check->fetchColumn();

    echo "✅ [成功] 天官賜福生效！\n";
    echo "   - 帳戶：$username\n";
    echo "   - 注入：$amount Z幣\n";
    echo "   - 當前餘額：$new_balance Z幣\n";

} catch (PDOException $e) {
    echo "❌ [失敗] 賜福錯誤：" . $e->getMessage();
}

echo "\n--------------------------------\n";
echo "請回到駕駛艙重新整理，享受揮霍的樂趣。";
?>