<?php
// get_tasks.php - 任務讀取 (V2.6 支援時長)
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
require_once 'db.php';

try {
    $sql = "SELECT * FROM tasks WHERE status = 'active' ORDER BY id DESC";
    $stmt = $pdo->query($sql);
    $tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($tasks as &$task) {
        // 預設圖
        $task['zoo_img'] = 'zoo_new_task';
        
        // 根據類型與獎勵換圖
        if ($task['action_type'] == 'LIKE') {
            $task['zoo_img'] = 'zoo_action_like';
        } elseif ($task['action_type'] == 'COMMENT') {
            $task['zoo_img'] = 'zoo_ask';
        } elseif ($task['reward'] >= 45) { 
            // 高獎勵任務 (60秒以上) 顯示富豪圖
            $task['zoo_img'] = 'zoo_rich'; 
        } elseif ($task['reward'] >= 200) {
            // 超級任務 (300秒) 顯示奇蹟圖
            $task['zoo_img'] = 'zoo_miracle';
        }
    }

    echo json_encode(["status" => "success", "data" => $tasks]);

} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
?>