<?php
// get_proofs.php - 墨家天眼：讀取待審案件
// --------------------------------------------------
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
require_once 'db.php';

try {
    // 撈出所有 status = 'pending' 的證據
    // 並且關聯出 任務內容(平台/動作) 和 傭兵名字
    $sql = "SELECT 
                tp.id as proof_id, 
                tp.proof_data, 
                tp.comment, 
                tp.created_at,
                t.platform, 
                t.action_type, 
                t.reward,
                u.username as worker_name
            FROM task_proofs tp
            JOIN tasks t ON tp.task_id = t.id
            JOIN users u ON tp.worker_id = u.id
            WHERE tp.status = 'pending'
            ORDER BY tp.created_at DESC";

    $stmt = $pdo->query($sql);
    $proofs = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(["status" => "success", "data" => $proofs]);

} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
?>