<?php
// find_sdk.php - 尋找失落的傳送門
header("Content-Type: text/plain; charset=utf-8");

// 定義我們要檢查的目標：上一層資料夾 (/flowzoo/)
$parent_dir = dirname(__DIR__); 

echo "🦁 Zoo Team 偵察報告\n";
echo "當前位置 (API): " . __DIR__ . "\n";
echo "上層位置 (Root): $parent_dir \n\n";

// 1. 檢查上層有什麼
echo "📂 [Level 1] 掃描 /flowzoo/ 目錄內容：\n";
$files = scandir($parent_dir);
$sdk_found = false;

foreach ($files as $file) {
    if ($file === '.' || $file === '..') continue;
    
    // 判斷是檔案還是資料夾
    $type = is_dir($parent_dir . '/' . $file) ? '[資料夾]' : '[檔案]  ';
    echo "$type $file\n";

    if ($file === 'sdk') {
        $sdk_found = true;
    }
}

echo "\n--------------------------------\n";

// 2. 如果發現了 sdk 資料夾，進去看看
if ($sdk_found) {
    echo "✅ 發現 'sdk' 資料夾！正在進入掃描...\n";
    $sdk_files = scandir($parent_dir . '/sdk');
    foreach ($sdk_files as $f) {
        if ($f === '.' || $f === '..') continue;
        echo "   👉 $f\n";
    }
} else {
    echo "❌ 嚴重警告：沒有發現名為 'sdk' 的資料夾！\n";
    echo "   (請確認您是否建成了 'SDK' 或放在了別的地方)\n";
}
?>