<?php
// create_task.php - 發布櫃台 (V2.6 時間定價版)
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
require_once 'db.php';

$input = file_get_contents("php://input");
$data = json_decode($input, true);

if (!isset($data['user_id']) || !isset($data['target_url'])) {
    echo json_encode(["status" => "error", "message" => "資料不完整"]); exit;
}

$user_id = $data['user_id'];
$platform = $data['platform'];
$action = $data['action_type'];
$url = $data['target_url'];
// 接收秒數，預設 20
$duration = isset($data['duration']) ? intval($data['duration']) : 20; 

// 定價模型：發布成本 = 秒數 (1秒1幣)
$COST = $duration; 
// 獎勵模型：執行獎勵 = 成本 * 0.75
$REWARD = floor($COST * 0.75);

$proof = ($platform == 'WEB') ? 'AUTO' : 'SCREENSHOT';

try {
    $pdo->beginTransaction();

    // 1. 檢查餘額
    $stmt = $pdo->prepare("SELECT coins FROM users WHERE id = :id");
    $stmt->execute([':id' => $user_id]);
    $balance = $stmt->fetchColumn();

    if ($balance < $COST) {
        throw new Exception("餘額不足！此任務需要 $COST Z幣");
    }

    // 2. 扣款
    $stmt = $pdo->prepare("UPDATE users SET coins = coins - :cost WHERE id = :id");
    $stmt->execute([':cost' => $COST, ':id' => $user_id]);

    // 3. 建立任務 (寫入 duration)
    $sql = "INSERT INTO tasks (user_id, platform, action_type, target_url, duration, proof_req, cost, reward) 
            VALUES (:uid, :plat, :act, :url, :dur, :proof, :cost, :rew)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':uid' => $user_id, ':plat' => $platform, ':act' => $action,
        ':url' => $url, ':dur' => $duration, ':proof' => $proof,
        ':cost' => $COST, ':rew' => $REWARD
    ]);

    $pdo->commit();
    echo json_encode(["status" => "success", "message" => "發布成功！扣除 $COST Z幣 (時長: {$duration}s)", "new_coins" => $balance - $COST]);

} catch (Exception $e) {
    $pdo->rollBack();
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
?>